/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.fluids.IFluidInfo;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.electrodynamics.ElectrodynamicsHelper;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"electrodynamics"})
public class ElectrodynamicsModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "chromium", "copper", "gold", "iron", "lead", "lithium", "molybdenum", "netherite", "netherite_scrap", "silver", "tin", "titanium", "vanadium"));
    private Map<IMaterial, IDynamicSpecConfig> configs;
    private final IForm impureDustForm = ApiImpl.INSTANCE.newForm(this, "electrodynamics_impuredusts", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT, MaterialType.INGOT_LEGACY).setSecondaryName("electrodynamics:impuredusts").setDefaultMaterialBlacklist(BLACKLIST);
    private final IForm crystalForm = ApiImpl.INSTANCE.newForm(this, "electrodynamics_crystals", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT, MaterialType.INGOT_LEGACY).setSecondaryName("electrodynamics:crystals").setDefaultMaterialBlacklist(BLACKLIST);
    private final IForm sulfateForm = ApiImpl.INSTANCE.newForm(this, "electrodynamics_sulfates", FluidFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT, MaterialType.INGOT_LEGACY).setSecondaryName("electrodynamics:sulfates").setDefaultMaterialBlacklist(BLACKLIST);

    @Override
    public String getName() {
        return "electrodynamics";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(ApiImpl.INSTANCE.newFormRequest(this, this.impureDustForm, this.crystalForm, this.sulfateForm));
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ResourceLocation oreLocation;
        ApiImpl api = ApiImpl.INSTANCE;
        ElectrodynamicsHelper helper = ElectrodynamicsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        FluidFormType fluidFormType = FluidFormType.INSTANCE;
        ResourceLocation sulfuricAcidLocation = new ResourceLocation("forge:sulfuric_acid");
        for (IMaterial material : this.sulfateForm.getMaterials()) {
            IFluidInfo sulfateInfo = fluidFormType.getMaterialFormInfo(this.sulfateForm, material);
            if (material.getType() == MaterialType.INGOT) {
                ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
                helper.registerMineralWasherRecipe(new ResourceLocation("jaopca", "electrodynamics.raw_material_to_sulfate." + material.getName()), rawMaterialLocation, 1, sulfuricAcidLocation, 1000, sulfateInfo, 1000, 0.0);
                continue;
            }
            oreLocation = miscHelper.getTagLocation("ores", material.getName());
            helper.registerMineralWasherRecipe(new ResourceLocation("jaopca", "electrodynamics.ore_to_sulfate." + material.getName()), oreLocation, 1, sulfuricAcidLocation, 1000, sulfateInfo, 1000, 0.0);
        }
        for (IMaterial material : this.crystalForm.getMaterials()) {
            ResourceLocation sulfateLocation = miscHelper.getTagLocation("electrodynamics:sulfates", material.getName());
            IItemInfo crystalInfo = itemFormType.getMaterialFormInfo(this.crystalForm, material);
            helper.registerChemicalCrystallizerRecipe(new ResourceLocation("jaopca", "electrodynamics.sulfate_to_crystal." + material.getName()), sulfateLocation, 100, crystalInfo, 1, 0.0);
        }
        Item sulfurTrioxide = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("electrodynamics:oxidetrisulfur"));
        for (IMaterial material : this.impureDustForm.getMaterials()) {
            oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation crystalLocation = miscHelper.getTagLocation("electrodynamics:crystals", material.getName());
            IItemInfo impureDustInfo = itemFormType.getMaterialFormInfo(this.impureDustForm, material);
            helper.registerMineralCrusherRecipe(new ResourceLocation("jaopca", "electrodynamics.ore_to_impure_dust." + material.getName()), oreLocation, 1, impureDustInfo, 3, 0.3);
            if (material.getType() == MaterialType.INGOT) {
                ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
                helper.registerMineralCrusherRecipe(new ResourceLocation("jaopca", "electrodynamics.raw_material_to_impure_dust." + material.getName()), rawMaterialLocation, 1, impureDustInfo, 3, 0.3);
            }
            helper.registerMineralCrusherRecipe(new ResourceLocation("jaopca", "electrodynamics.crystal_to_impure_dust." + material.getName()), crystalLocation, 1, impureDustInfo, 1, sulfurTrioxide, 1, 0.19, 0.1);
        }
        for (IMaterial material : moduleData.getMaterials()) {
            oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation impureDustLocation = miscHelper.getTagLocation("electrodynamics:impuredusts", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("electrodynamics.byproduct", "minecraft:cobblestone", s -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s)), "The byproduct material to output in Create's crushing.");
            Item byproduct = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(configByproduct));
            helper.registerMineralGrinderRecipe(new ResourceLocation("jaopca", "electrodynamics.ore_to_dust." + material.getName()), oreLocation, 1, dustLocation, 2, byproduct, 1, 0.1, 0.3);
            if (material.getType() == MaterialType.INGOT) {
                ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
                helper.registerMineralGrinderRecipe(new ResourceLocation("jaopca", "electrodynamics.raw_material_to_dust." + material.getName()), rawMaterialLocation, 1, dustLocation, 2, 0.3);
            }
            helper.registerMineralGrinderRecipe(new ResourceLocation("jaopca", "electrodynamics.impure_dust_to_dust." + material.getName()), impureDustLocation, 1, dustLocation, 1, 0.1);
        }
    }
}

